;
;		MAKESUB.ASM
;	     (revised 4/28/80)
;
;11/04/79 FIRST WRITTEN BY KEITH PETERSEN
;	  AND BOB MATHIAS.
;
;04/28/80 UPDATED FOR MORE EFFICIENT CODING BY
;	  CLAYTON HIBBERT AND KEITH PETERSEN.
;
;THIS PROGRAM DEMONSTRATES HOW ONE CP/M COM
;PROGRAM CAN EXECUTE ANOTHER COM PROGRAM.
;THE SECRET IS IN CREATING A FILE CALLED
;"$$$.SUB" WHICH CONTAINS THE COMMAND TO
;EXECUTE THE NEXT PROGRAM. AFTER DOING THAT,
;A JMP TO WARM BOOT (0000H) WILL CAUSE CP/M
;TO DO A SUBMIT OF THAT COMMAND.
;
;
DRNAME	EQU	4	;ADDR. WHERE DRIVE NAME IS
BDOS	EQU	5
FCB	EQU	5CH
FCBEX	EQU	FCB+12
FCBNR	EQU	FCB+32
BUFF	EQU	80H	;CP/M DEFAULT BUFFER
MAKE	EQU	22
WRITE	EQU	21
CLOSE	EQU	16
;
	ORG	100H
;
	LXI	H,FILNAM ;POINT TO FILENAME
	LXI	D,FCB	;POINT TO FCB
	MVI	B,13	 ;LENGTH OF FILENAME
	CALL	MOVER	;MOVE IT TO FCB
;
;	GO MAKE THE FILE
;
	XRA	A
	STA	FCBNR	;SET RECORD NUMBER TO ZERO
	LXI	D,FCB	;POINT TO NAME
	MVI	C,MAKE	;MAKE FILE
	CALL	BDOS
;
;	GET THE NAME TO PUT IN FILE
;
	LXI	H,COMNAM ;POINT TO COMMAND STRING
	LXI	D,BUFF	;POINT TO FCB
	MVI	B,NAMLEN ;LENGTH OF MOVE
	CALL	MOVER	;MOVE NAME INTO BUFFER
;
;	WRITE FILE NAME TO DISK
;
	LXI	D,FCB	;POINT TO NAME
	MVI	C,WRITE	;WRITE RECORD
	CALL	BDOS
;	
;	NOW CLOSE THE FILE ON DISK
;
	LXI	D,FCB	;POINT TO NAME
	MVI	C,CLOSE	;CLOSE FILE
	CALL	BDOS
;
;	INSURE THE DISK WE WANT TO SUBMIT ON
;
	XRA	A	;GET A ZERO
	STA	DRNAME	;SET CP/M FOR DRIVE A:
	JMP	0	;REBOOT
;
;MOVE (B) BYTES FROM (HL) TO (DE)
;
MOVER:	MOV	A,M	;GET BYTE FROM SOURCE
	STAX	D	;STORE AT DESTINATION
	INX	H	;INCREMENT SOURCE ADR
	INX	D	;INCREMENT DESTINATION ADR
	DCR	B	;DECREMENT MOVE COUNTER
	JNZ	MOVER	;NOT DONE, DO MORE	
	RET
;
FILNAM	DB	1	;DRIVE NAME 1=A
	DB	'$$$     SUB' ;NAME OF SUBMIT FILE
	DB	0	;SET EXTENT NR TO ZERO
;
COMNAM	DB	NAMLEN -2 AND 0FFH ; ACTUAL LENGTH OF COMMAND
	DB	'DIR'	;PUT COMMAND HERE
	DB	0	;END WITH ZERO
NAMLEN	EQU	$-COMNAM ;LENGTH OF NAME
;
	END

